texture g_MeshTexture;               // Color texture for mesh
texture g_MeshHeightmap;               // POM heightmap
texture g_MeshLightmap;               // Lightmap for mesh 
texture g_Wavemap;                  // Normal mapp

float4x4 g_mWorldViewProjection;	// World * View * Projection 
float4x4 g_mWorldView;	          // World * View matrix
float4x4 g_mProjectionKorr;	  // World * Korr
float4 g_vMotionVec;
float4 g_CameraPosition;

float FogStart;
float FogEnd;

float HDRszorzo;

float BlendFactor;

sampler MeshTextureSampler = 
sampler_state
{
    Texture = <g_MeshTexture>;
    MipFilter = NONE;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP; 
};

sampler MeshTextureSampler2 = 
sampler_state
{
    Texture = <g_MeshTexture>;
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = MIRROR;
    AddressV = MIRROR; 
};

sampler MeshTextureSampler3 = 
sampler_state
{
    Texture = <g_MeshTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;  
};

sampler MeshLightmapSampler = 
sampler_state
{
    Texture = <g_MeshLightmap>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;  
};


sampler MeshHeightmapSampler = 
sampler_state
{
    Texture = <g_MeshHeightmap>;
    MipFilter = NONE;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = WRAP;
    AddressV = WRAP;  
};

sampler MeshHeightmapSampler2 = 
sampler_state
{
    Texture = <g_MeshHeightmap>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;  
};

sampler WaveSampler = 
sampler_state
{
    Texture = <g_Wavemap>;
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = MIRROR;
    AddressV = MIRROR; 
};

sampler WaveTexSampler = 
sampler_state
{
    Texture = <g_Wavemap>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP; 
};

float2 g_Offset[12];



//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;    
};

struct PS_INPUT
{   
    float4 TextureUV : TEXCOORD0;     
};

struct VS_OUTPUT
{   
    float4 Position  : POSITION;   
    float4 TextureUV : TEXCOORD2;
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
};

struct PS_INPUT2
{   
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
    float4 TextureUV : TEXCOORD2;    
};

struct VS_INPUT_POM
{
    float4 Position  : POSITION;    
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
    float4 normal    : NORMAL;    
    float4 tangent   : TANGENT0;
    float4 binormal  : BINORMAL0;
};

struct PS_INPUT_POM
{   
    float  Fog       : FOG;
    float4 Position  : POSITION;
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
    float3 ray    : TEXCOORD2;    
};


//--------------------------------------------------------------------------------------
// Full screen glow
//--------------------------------------------------------------------------------------


PS_OUTPUT FullScreenGlowPS( PS_INPUT In) 
{ 
    PS_OUTPUT Output;  
    float4 ertek;
    float4 tex=tex2D(MeshTextureSampler, In.TextureUV);
    Output.RGBColor  = 0 ;// tex2D(MeshTextureSampler, In.TextureUV);
    ertek=tex+0.5;

	for(int i=0; i < 12; i++ )
	{
          
          Output.RGBColor += max(0,tex2D(MeshTextureSampler,In.TextureUV + g_Offset[i])-ertek);
       
	}  

    Output.RGBColor =Output.RGBColor/10;
    return Output;
}


//--------------------------------------------------------------------------------------
// Full screen red-grey-stuff.
//--------------------------------------------------------------------------------------


PS_OUTPUT FullScreenGreyscalePS( PS_INPUT In) 
{ 
    PS_OUTPUT Output;  
    float3 tex=tex2D(MeshTextureSampler, In.TextureUV);
    float2 ujUV = In.TextureUV-0.5;
    float tav =1.3-sqrt(ujUV.x*ujUV.x+ujUV.y*ujUV.y);
    float szurk=(tex.r+tex.g+tex.b)*2*tav-1.2;
    szurk=saturate(szurk);
    float4 vegso;
    vegso.r = szurk;
    szurk = szurk*szurk;
    vegso.g = szurk;
    vegso.b = szurk;
    vegso.a = BlendFactor;
    Output.RGBColor  = vegso;
    
    return Output;
}


//--------------------------------------------------------------------------------------
// Full screen motion blur
//--------------------------------------------------------------------------------------


PS_OUTPUT MotionBlurPS( PS_INPUT In) 
{ 
    PS_OUTPUT Output;  
    float2 vOffset;
    float2 vPrecomp=(In.TextureUV.xy-0.5)*g_vMotionVec.z+g_vMotionVec.xy;
    vPrecomp*=0.01;
    float fKill= vPrecomp.x*vPrecomp.x+vPrecomp.y*vPrecomp.y;
    clip(fKill-0.00000015);
    Output.RGBColor = 0;
    for(int i=0; i < 8; i++ )
    {
          vOffset=vPrecomp*i;     
          Output.RGBColor += tex2D(MeshTextureSampler,In.TextureUV + vOffset)*(8-i);
       
	}    
    Output.RGBColor = Output.RGBColor/36;
    return Output;
}


//--------------------------------------------------------------------------------------
// Simple Water reflection shader
//--------------------------------------------------------------------------------------

VS_OUTPUT WaterReflectionVS( float4 vPos : POSITION, 
                         float4 vTexCoord0 : TEXCOORD0,
                         float4 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;
  
    Output.Position = mul(vPos, g_mWorldViewProjection);
   
    Output.TextureUV = mul(vPos, g_mWorldView);
    
    Output.TexUV1 = vTexCoord0;
    Output.TexUV2 = vTexCoord1;
    return Output;    
}

PS_OUTPUT WaterReflectionPS( VS_OUTPUT In) 
{ 
    PS_OUTPUT Output; 
    float4 reflvec=tex2D(WaveTexSampler,In.TexUV1)+tex2D(WaveTexSampler,In.TexUV2)-1;
    reflvec.w=0;

    float3 ref2=mul(reflvec.xzyw,g_mWorldView);
    float3 ev=normalize(In.TextureUV.xyz);
    float fresnel=dot(ref2,ev)+1;

    reflvec.z=0;
    float4 hova=In.TextureUV+reflvec;

    hova=mul(hova,g_mProjectionKorr);
    float4 vizcol={0.25,0.6,0.8,1};
        Output.RGBColor=lerp(tex2Dproj(MeshTextureSampler2,hova),vizcol,0.2);
    Output.RGBColor.a=fresnel*0.8;
   
    return Output;
}



PS_INPUT_POM ParallaxOcclusionVS( VS_INPUT_POM In) 
{ 
    PS_INPUT_POM Output;
    float3 rayws = g_CameraPosition-In.Position;
    float3 ray;
    ray.y = -dot(rayws,In.tangent);
    ray.x = dot(rayws,In.binormal);
    ray.z = dot(rayws,In.normal);
    

    Output.Position= mul(In.Position, g_mWorldViewProjection);
   if (ray.z>0)
   {
    ray.z += 0.3;
   }else
   {
    ray.z = 0.1-ray.z;
   };
    //ray=normalize(ray);
   // ray.z= max(0,ray.z*10);
    ray.z=ray.z*10;
    Output.ray  = ray;
    Output.TexUV1  = In.TexUV1;
    Output.TexUV2  = In.TexUV2;
    Output.Fog = 1- saturate((Output.Position.z-FogStart)/(FogEnd-FogStart));   
 
    return Output;
}

PS_OUTPUT ParallaxOcclusionPS( PS_INPUT_POM In) 
{ 
    PS_OUTPUT Output;
    float2 texpos=In.TexUV1;
    
    float3 ray=In.ray/In.ray.z;
    float3 currpos;
    float3 texmin;
    texmin.xy = texpos.xy - ray.xy*0.5;
    texmin.z=0;

    currpos = texmin;

    ray=ray/7;


    float elozo;
    float kovetkezo=tex2D(MeshHeightmapSampler2,currpos).r;
    float doles=1;
    float kul=0;
    float kul2;

    for (int i=0; i<7; i++)
    { 
       currpos=currpos+ray;
      elozo=kovetkezo;
      kovetkezo=tex2D(MeshHeightmapSampler2,currpos).r;
      kul2=elozo-currpos.z;

      if (kul2>0)
      { 
       texmin=currpos;
       kul=kul2;
       doles=elozo-kovetkezo+ray.z;
      };            
    };
    
    texmin=texmin+ray*(kul/doles);
    Output.RGBColor  = tex2D(MeshTextureSampler3,texmin)*tex2D(MeshLightmapSampler,In.TexUV2)*HDRszorzo;

    return Output;
}

technique FullScreenGlow
{
    pass P0
    {
        PixelShader  = compile ps_2_0 FullScreenGlowPS(); 
    }
}

technique FullScreenGreyscale
{
    pass P0
    {
        PixelShader  = compile ps_2_0 FullScreenGreyscalePS(); 
    }
}

technique MotionBlur
{
    pass P0
    {
        PixelShader  = compile ps_2_0 MotionBlurPS(); 
    }
}

technique WaterReflection
{
    pass P0
    {
        VertexShader = compile vs_2_0 WaterReflectionVS(); 
        PixelShader  = compile ps_2_0 WaterReflectionPS(); 
    }
}

technique ParallaxOcclusion
{
    pass P0
    {   
        VertexShader = compile vs_2_0 ParallaxOcclusionVS();
        PixelShader  = compile ps_2_0 ParallaxOcclusionPS(); 
    }
}
